function [bxmin,bymin,bxmax,bymax]=computebbox(vertices,elements)
%COMPUTEBBOX  Bounding-boxes of the triangles
%   [BXMIN,BYMIN,BXMAX,BYMAX]=COMPUTEBBOX(P,T) computes the bounding-boxes
%   of a pdetool triangular mesh i.e. the rectangles (BXMIN,BYMIN)-(BXMAX,BYMAX)
%   for each triangle.

% F.Saleri, 21.11.02

ve=vertices(1,elements(1:3,:));
me=ve(1:3:end); me=[me' ve(2:3:end)']; 
me=[me ve(3:3:end)']; 
bxmin = min(me,[],2); 
bxmax = max(me,[],2);
ve=vertices(2,elements(1:3,:));
me=ve(1:3:end); me=[me' ve(2:3:end)']; 
me=[me ve(3:3:end)']; 
bymin = min(me,[],2); 
bymax = max(me,[],2);

return